#include <stdio.h>
#include <stdlib.h>
#include<math.h>

void draw(double x1, double y1, double r1, double r2, double angle1)
{
    double x2, y2, x3, y3, angle2;

    if(angle1 > M_PI) angle2 = angle1 - M_PI;
    else angle2 = angle1 + M_PI;
    x2 = x1 + r1 * cos(angle1);
    y2 = y1 + r1 * sin(angle1);
    x3 = x1 + r1 * cos(angle1 + M_PI/3.);
    y3 = y1 + r1 * sin(angle1 + M_PI/3.);
    printf("color 0 3 0\n");
    printf("connect %f %f %f %f\n", ((r1 + r2) * x1 - r2 * x2)/r1, ((r1 + r2) * y1 - r2 * y2)/r1, ((r1 + r2) * x2 - r2 * x1)/r1, ((r1 + r2) * y2 - r2 * y1)/r1);
    printf("connect %f %f %f %f\n", ((r1 + r2) * x2 - r2 * x3)/r1, ((r1 + r2) * y2 - r2 * y3)/r1, ((r1 + r2) * x3 - r2 * x2)/r1, ((r1 + r2) * y3 - r2 * y2)/r1);
    printf("connect %f %f %f %f\n", ((r1 + r2) * x3 - r2 * x1)/r1, ((r1 + r2) * y3 - r2 * y1)/r1, ((r1 + r2) * x1 - r2 * x3)/r1, ((r1 + r2) * y1 - r2 * y3)/r1);
    printf("color 0 0 3\n");
    printf("circle %f %f %f %d %d\n", x1, y1, r1 + r2, (int) (180. * 64 * angle1/M_PI), 60 * 64);
    printf("circle %f %f %f %d %d\n", x1, y1, r2, (int) (180. * 64 * angle2/M_PI), 60 * 64);
    printf("circle %f %f %f %d %d\n", x2, y2, r1 + r2, (int) (180. * 64 * angle1/M_PI) + 120 * 64, 60 * 64);
    printf("circle %f %f %f %d %d\n", x2, y2, r2, (int) (180. * 64 * angle2/M_PI) + 120 * 64, 60 * 64);
    printf("circle %f %f %f %d %d\n", x3, y3, r1 + r2, (int) (180. * 64 * angle1/M_PI) + 240 * 64, 60 * 64);
    printf("circle %f %f %f %d %d\n", x3, y3, r2, (int) (180. * 64 * angle2/M_PI) + 240 * 64, 60 * 64);
}

main(argc, argv)
    int argc;
    char *argv[];
{
    int i, j, adp = 1;
    double t , dt = .01;

    if(argc > 1) dt = atof(argv[1]);
    printf("active %d\n", adp);
    for(t = M_PI/2.; t > M_PI/6.; t -= dt) {
        printf("color 1 1 1\npolygon -20. -5. 20. -5. 20. -8 -20. -8.\n");
        printf("color 3 0 0\npolygon %f 5. %f 5. %f 5.5 %f 5.5\n", -13. + 10. * (M_PI/6. - t), 13. + 10. * (M_PI/6. - t), 13. + 10. * (M_PI/6. - t), -13. + 10. * (M_PI/6. - t));
        draw(-11.5 + 2. * (M_PI/2. - t), -3., 6., 2., t);
        draw(1.5 + 8 * (M_PI/2. - t), 3., 6., 2., M_PI + t);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\nclear %d\n", adp, adp);
    }
    for(t = 0.; t < M_PI/3.; t += dt) {
        printf("color 1 1 1\npolygon -20. -5. 20. -5. 20. -8 -20. -8.\n");
        printf("color 3 0 0\npolygon %f 5. %f 5. %f 5.5 %f 5.5\n", -13. + 10. * t, 13. + 10. * t, 13. + 10. * t, -13. + 10. * t);
        draw(8. * t - 11.5 + 2. * M_PI/3., 3., 6., 2., 3. * M_PI/2. - t);
        draw(1.5 + 8. * M_PI/3. + 2. * t, -3., 6., 2., M_PI/2. - t);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\nclear %d\n", adp, adp);
    }
    return 0;
/*    draw(0., 0., 6., 2., 0.);
*/
}
