#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define GOSA .00001

typedef struct eqnofline {
	double a, b, c;
} eql;
typedef struct point {
	double x, y;
} PT;

int fdallsol(int n, double c[], double d[]);
eql eq[6], eq0;
PT point[3];
double st[4], c[10], d[10], cc[4], z[3];

void cubiceq(eql l1, eql l2, eql l3, double c[])
{
    c[0] = l1.a * l2.a * l3.a;
    c[1] = l1.a * (l2.a * l3.b + l2.b * l3.a) + l1.b * l2.a * l3.a;
    c[2] = l1.a * l2.b * l3.b + l1.b * (l2.a * l3.b + l2.b * l3.a);
    c[3] = l1.b * l2.b * l3.b;
    c[4] = l1.a * (l2.a * l3.c + l2.c * l3.a) + l1.c * l2.a * l3.a;
    c[5] = l1.a * l2.b * l3.c + l1.a * l2.c * l3.b + l1.b * l2.a * l3.c + l1.b * l2.c * l3.a + l1.c * l2.a * l3.b + l1.c * l2.b * l3.a;
    c[6] = l1.b * (l2.b * l3.c + l2.c * l3.b) + l1.c * l2.b * l3.b;
    c[7] = l1.a * l2.c * l3.c + l1.c * (l2.a * l3.c + l2.c * l3.a);
    c[8] = l1.b * l2.c * l3.c + l1.c * (l2.b * l3.c + l2.c * l3.b);
    c[9] = l1.c * l2.c * l3.c;
    return ;
}

int main(int argc, char *argv[])
{
    int i, j, n, adp = 1;
    double ab, cb, ca, a2b2, sqa2b2, x, y, t;

    if(argc < 5) {
	st[0] = 0.; st[1] = 1.1; st[2] = 2.3; st[3] = 4.7;
    }
    else {
	for(i = 0; i < 4; i++) st[i] = atof(argv[i + 1]);
    }
    for(i = 0; i < 4; i++) {
	eq[i].a = cos(st[i]);
	eq[i].b = sin(st[i]);
	eq[i].c = -1.;
    }
    printf("circle 0 0 1\ncolor 1 3 1\n");
    for(i = 0; i < 4; i++) {
	printf("line %f %f %f\n", eq[i].a, eq[i].b, eq[i].c);
    }
    eq[5].a = eq[0].a + eq[1].a; eq[5].b = eq[0].b + eq[1].b; eq[5].c = eq[0].c + eq[1].c;
    eq[4].a = eq[2].a + eq[3].a; eq[4].b = eq[2].b + eq[3].b; eq[4].c = eq[2].c + eq[3].c;
    cubiceq(eq[0], eq[1], eq[4], c);
    cubiceq(eq[2], eq[3], eq[5], d);
    for(i = 0; i < 10; i++) c[i] += d[i];
    printf("color 0 0 3\n");
//    printf("gray 0.\n");
    printf("curve %fx3+%fx2y+%fxy2+%fy3+%fx2+%fxy+%fy2+%fx+%fy+%f\n", c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9]);
    printf("pause\ncolor 3 0 0\n");
    for(t = st[0]; t < st[1]; t += .01) {
	eq0.a = cos(t); eq0.b = sin(t); eq0.c = -1.;
	if((eq0.b < GOSA) && (eq0.b > -GOSA)) {
	    ca = -eq0.c / eq0.a;
	    cc[0] = c[3];
	    cc[1] = c[2] * ca + c[6];
	    cc[2] = (c[1] * ca + c[5]) * ca + c[8];
	    cc[3] = ((c[0] * ca + c[4]) * ca + c[7]) * ca + c[9];
	    n = fdallsol(3, cc, z);
	    for(i = 0; i < n; i++) {
		point[i].x = ca;
		point[i].y = z[i];
	    }
	}
	else {
	    ab = -eq0.a / eq0.b; cb = -eq0.c / eq0.b;
	    cc[0] = c[0] + ab * (c[1] + ab * (c[2] + ab * c[3]));
	    cc[1] = c[4] + ab * (c[5] + ab * c[6]) + cb *(c[1] + ab *(2 * c[2] + 3 * ab * c[3]));
	    cc[2] = c[7] + ab * c[8] + cb * (cb * (c[2] + 3 * ab * c[3]) + c[5] + 2 * ab * c[6]);
	    cc[3] = c[9] + cb * (c[8] + cb * (c[6] + cb * c[3]));
	    n = fdallsol(3, cc, z);
	    for(i = 0; i < n; i++) {
		point[i].x = z[i];
		point[i].y = ab * z[i] + cb;
	    }
	}
	printf("active %d\ncopy 0 %d\n", adp, adp);
	printf("line %f %f %f\n", eq0.a, eq0.b, eq0.c);
	for(i = 0; i < n; i++) {
	    x = point[i].x; y = point[i].y;
	    a2b2 = x * x + y * y;
	    sqa2b2 = sqrt(a2b2 - 1.);
	    printf("line %f %f %f\n", x + y * sqa2b2, y - x * sqa2b2, -a2b2);
	    printf("line %f %f %f\n", x - y * sqa2b2, y + x * sqa2b2, -a2b2);
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("tsleep 10\n");
    }
    return 0;
}
